define([
    'underscore',
    'marionette',
    'text!modules/appointments/booked/pagination/booked-appointments-bottom-pagination.html',
    'modules/appointments/appointments-module',
    'backbone',
    'backgrid',
    'backgrid-paginator',
],
function (_, Marionette, template, module, Backbone, Backgrid, BackgridPaginator) {
    'use strict';

    return Marionette.View.extend({

        template: _.template(template),

        initialize: function(options) {
            this.jquerySelector = options.jquerySelector || '#bottom-paginator-div';
            this.addRegions({
                paginator: this.jquerySelector,
            });

            this.childView = new Backgrid.Extension.Paginator({
                collection: this.collection,
                windowSize: this.collection.length,
                // pageHandle: this.pageHandle,
            });
        },
        onShow: function() {
            // windowSize defines # of pages shown to begin. [VAR-12341]
            this.showChildView('paginator', this.childView);
        },
        onRender: function() {
            if (this.collection !== undefined && this.collection.fullCollection !== undefined &&
                this.collection.fullCollection.length > 0) {
                this.onShow();
            }
        },

    });
}
);
